# coding: utf-8
import os
import shutil
import time


def wait_for_downloads(file_name, timeout=60):
    """
    监控下载文件，等待新文件下载完成。
    :param file_name: 文件下载目录
    :param timeout: 超时时间，单位：秒
    """
    end_time = time.time() + timeout
    while time.time() < end_time:
        files = os.path.isfile(file_name)
        if files:
            return True
        time.sleep(0.5)
    return False


def make_dir(path):
    # 检查下载目录是否存在，如果不存在则创建
    if not os.path.exists(path):
        os.makedirs(path)
        return False

    return True


def move_file(src, dest):
    """
    将文件从 src 移动到 dest。

    :param src: 源文件路径
    :param dest: 目标文件路径
    :return: None
    """
    try:
        # 检查源文件是否存在
        if not os.path.exists(src):
            raise FileNotFoundError(f"源文件 {src} 不存在")

        # 检查目标文件夹是否存在，如果不存在则创建
        dest_dir = os.path.dirname(dest)
        if not os.path.exists(dest_dir):
            os.makedirs(dest_dir)

        # 使用 shutil.move 来移动文件
        shutil.move(src, dest)
    except Exception as e:
        print(f"移动文件时出错: {e}")