# coding: utf-8
import os

from app.helper import file, domain, helper
from app.vc.payment import Payment
from app.vc.return_goods import ReturnGoods
from app.vc.spa import Spa
from DrissionPage import ChromiumPage
from dotenv import load_dotenv

if __name__ == '__main__':
    load_dotenv()

    page = ChromiumPage()
    page.set.load_mode.normal()
    page.set.when_download_file_exists('overwrite')
    # 下载目录
    download_path = os.getcwd()
    # 检查下载目录是否存在，如果不存在则创建
    file.make_dir(download_path)
    # 设置下载路径，确保在打开浏览器前设置
    page.set.download_path(download_path)

    try:
        country = helper.get_input_with_default("国家: [ DE, FR, JP, CA, UK, US ]", "US")
        shop_code = helper.get_input_with_default("店铺编码: [ DE-VC, FR-VC, JP-VC, CA-VC, UK-VC, VECELO ]", "VECELO")
        payee_code = helper.get_input_with_default("回款Code: [ 详情页url参数 payeeCode ]", "VECET")
        action = helper.get_input_with_default("功能:[ spa, return, payment ]", "")
        file_name = helper.get_input_with_default("文件名 : [ 例如: ContraCogsInvoices.xls ]", "")
        if action.lower() == "payment":
            object_instate = Payment(page, country, payee_code, shop_code)
        elif action.lower() == "return":
            object_instate = ReturnGoods(page, country, payee_code, shop_code)
        elif action.lower() == "spa":
            object_instate = Spa(page, country, payee_code, shop_code)
        else:
            raise Exception("请输入正确的功能")

        if file_name == "":
            raise Exception("请输入文件名")

        domain.domain_page(page, country)

        object_instate.run(file_name)

    except KeyboardInterrupt:
        pass
    except Exception as e:
        helper.print_trace("main", e)
    finally:
        page.close()
