# coding: utf-8
# 广告费
import os
import warnings

import pandas as pd
from dotenv import load_dotenv

from helper import helper, logger, redisx, rabbitmq
from helper import api


# 忽略 openpyxl 样式警告
warnings.filterwarnings("ignore", category=UserWarning, module="openpyxl")

country = None
payeeCode = None
shop_code = None

load_dotenv()

log = logger.ConsoleLog()
rdb = redisx.RedisClient()


def main():
    # 读取sku映射关系
    relations_dict = api.sku_relations(country)

    file_name = "Sponsored_Products_Advertised_product_report.xlsx"
    if not os.path.isfile(file_name):
        raise FileNotFoundError(f"{file_name},文件不存在")

    result = pd.read_excel(file_name, keep_default_na=False, na_values=[])

    log.info(f"共计：{len(result)} 订单")

    rabbit = rabbitmq.RabbitMQClient()
    rabbit.connect(queue='advertising_robot', routing_key='advertising_robot', exchange='reports')

    for _, data in result.iterrows():
        relation = relations_dict.get(data.get('Advertised ASIN',""), {})
        push_data = {
            'ad_date': str(data.get("End Date", "")),  # 日期
            'erp_sku': relation.get('erp_sku', ""),  # erp_sku
            'ad_amount': data.get("Spend", 0),  # 金额
            'ad_amount_currency': data.get("Currency", ""),  # 币种
            'operator_name': "",  # 运营名
            'group_code': relation.get("code", ""),
            'asin': data.get("Advertised ASIN", ""),  # asin
            'shop_code': shop_code,  # 店铺code
        }
        rabbit.send_message(push_data)


if __name__ == '__main__':
    try:
        country = helper.get_input_with_default("国家(目前支持[DE,FR,JP,CA,UK,US])", "US")
        shop_code = helper.get_input_with_default("店铺编码(DE-VC,FR-VC,JP-VC,CA-VC,UK-VC,VECELO])", "VECELO")
        main()
    except KeyboardInterrupt:
        pass
    except Exception as e:
        log.error(e)
        helper.print_trace("main", e)
