import email
import imaplib
from email.header import decode_header

# 邮箱账户信息
username = 'us-cs001@khdtek.com'  # 更换为你的邮箱
password = 'khd=20221208'  # 更换为你的邮箱密码
imap_server = 'imap.qiye.aliyun.com'


def get_latest_unread_email():
    # 连接到 IMAP 服务器
    mail = imaplib.IMAP4_SSL(imap_server)
    mail.login(username, password)

    # 选择收件箱
    mail.select("inbox")

    # 搜索未读邮件
    status, messages = mail.search(None, 'UNSEEN')
    if status != 'OK':
        print("没有找到未读邮件")
        return

    # 获取邮件 ID
    email_ids = messages[0].split()

    if not email_ids:
        print("没有未读邮件")
        return

    # 获取最新的未读邮件 ID（最后一个 ID）
    latest_email_id = email_ids[-1]

    # 获取邮件内容
    status, msg_data = mail.fetch(latest_email_id, '(RFC822)')
    if status != 'OK':
        print("无法获取邮件")
        return

    # 解析邮件内容
    for response_part in msg_data:
        if isinstance(response_part, tuple):
            msg = email.message_from_bytes(response_part[1])

            # 获取邮件主题
            subject, encoding = decode_header(str(msg["Subject"]))[0]
            if isinstance(subject, bytes):
                subject = subject.decode(encoding if encoding else "utf-8")

            # 获取发件人
            from_ = msg.get("From")

            # 获取发送时间
            date_ = msg.get("Date")

            print(f"最新未读邮件主题: {subject}")
            print(f"发件人: {from_}")
            print(f"发送时间: {date_}")

            # 获取邮件正文内容
            if msg.is_multipart():
                # 如果邮件是多部分的
                for part in msg.walk():
                    content_type = part.get_content_type()
                    content_disposition = str(part.get("Content-Disposition"))

                    # 只处理文本或 HTML 内容
                    if content_type == "text/plain" and "attachment" not in content_disposition:
                        body = part.get_payload(decode=True).decode()  # 解码邮件内容
                        print("邮件正文（纯文本）:", body)
                    elif content_type == "text/html" and "attachment" not in content_disposition:
                        html_body = part.get_payload(decode=True).decode()  # 解码邮件内容
                        print("邮件正文（HTML）:", html_body)
            else:
                # 如果邮件不是多部分的
                body = msg.get_payload(decode=True).decode()
                print("邮件正文:", body)

    # 登出
    mail.logout()


# 执行获取最新未读邮件的操作
get_latest_unread_email()
