# coding: utf-8

import configparser
import os

from sqlalchemy import create_engine, text
from sqlalchemy.orm import sessionmaker

from models import Base

# 创建 configparser 对象
config = configparser.ConfigParser()
db_session = None


def init():
    # 配置文件路径
    config_file = 'config.ini'
    # 检查配置文件是否存在
    if not os.path.exists(config_file):
        raise FileNotFoundError(f"配置文件 {config_file} 不存在.")

    # 读取配置文件
    config.read(config_file)

    init_mysql()


def init_mysql():
    global db_session
    try:
        host = config.get('database', 'host')
        port = config.get('database', 'port')
        database = config.get('database', 'database')
        username = config.get('database', 'username')
        password = config.get('database', 'password')

        engine = create_engine(url=f"mysql+pymysql://{username}:{password}@{host}:{port}/{database}",
                               pool_recycle=3600,
                               echo=True)

        # 测试连接是否正常
        with engine.connect() as connection:
            connection.execute(text("SELECT 1"))

        Base.metadata.create_all(engine)
        db_session = sessionmaker(bind=engine)

        print("数据库连接成功，Session 初始化完成。")
    except Exception as e:
        raise FileNotFoundError(f"数据库连接失败: {e}")
