# coding: utf-8
# 回款明细
import os

import pandas as pd
from DrissionPage import ChromiumPage
from DrissionPage.errors import PageDisconnectedError, ElementNotFoundError

from helper import helper

page = ChromiumPage()
page.set.load_mode.eager()
page.set.when_download_file_exists('overwrite')

# 下载目录
download_path = os.getcwd()
# 检查下载目录是否存在，如果不存在则创建
helper.make_dir(download_path)
# 设置下载路径，确保在打开浏览器前设置
page.set.download_path(download_path)


def export_list_read_data():
    file_name = "ContraCogsInvoices.xls"
    if not os.path.isfile(file_name):
        page.get("https://vendorcentral.amazon.com/hz/vendor/members/coop?ref_=vc_xx_subNav")
        # 全选
        page.ele("#select-all").click()
        # 点击选项卡
        page.ele("#cc-invoice-actions-dropdown").click()
        # 点击下载报表
        page.ele("#cc-invoice-actions-dropdown_2").click.to_download().wait()

    return pd.read_excel(file_name, engine='xlrd')


def export_item_read_data(invoice_id):
    try:
        file_name = f"coop\\{invoice_id}.csv"
        if not os.path.isfile(file_name):
            page.get(f"https://vendorcentral.amazon.com/hz/vendor/members/coop?searchText={invoice_id}")
            # 点击选项卡
            page.ele("#a-autoid-2-announce").click()
            # 下载报表
            file_name = f"coop\\{invoice_id}.csv"
            page.ele(f"#invoiceDownloads-{invoice_id}_1").click.to_download(rename=file_name).wait()
            return pd.read_csv(file_name, engine='python', on_bad_lines='skip')
    except ElementNotFoundError:
        print("导出按钮不存在刷新网页")
        page.refresh()
        export_item_read_data(invoice_id)


def main():
    coop_data = export_list_read_data()
    for _, data in coop_data.iterrows():
        # 根据回款id搜索下载报表
        invoice_id = data.get("Invoice ID")
        print(invoice_id)
        export_item_read_data(invoice_id)

    page.close()

if __name__ == '__main__':
    try:
        main()
    except KeyboardInterrupt:
        pass
    except PageDisconnectedError as e:
        print("与页面的连接已断开")
