import pandas as pd
from DrissionPage import ChromiumPage

from app.vc.spa import Spa
from app.helper.logger import ConsoleLog


def calculate_totals(file_path):
    # 读取Excel文件
    xls = pd.ExcelFile(file_path)

    # 初始化总金额和总行数
    total_amount = 0
    total_rows = 0

    # 处理Sheet1的Original balance
    sheet1_df = pd.read_excel(xls, 'Sheet1')

    # 清洗Original balance列，去除$和千位分隔符
    sheet1_df['Original balance'] = sheet1_df['Original balance'].astype(str).str.replace(r'[\$,]', '', regex=True)
    # 转换为数值型，处理非数值数据
    sheet1_df['Original balance'] = pd.to_numeric(sheet1_df['Original balance'], errors='coerce')

    # 计算总和，忽略NaN
    sheet1_total = sheet1_df['Original balance'].sum(skipna=True)
    print(f"Sheet1 的总金额: {sheet1_total}")

    total_amount += sheet1_total

    # 根据Invoice ID去重，保留第一条记录
    unique_invoices = sheet1_df['Invoice ID'].drop_duplicates()
    # 计算去重后的行数
    unique_count = len(unique_invoices)

    total_rows += unique_count

    # 处理其他sheet的Rebate In Agreement Currency或Vendor Funding In Agreement Currency
    for sheet_name in xls.sheet_names:
        if sheet_name == 'Sheet1':
            continue

        try:
            df = pd.read_excel(xls, sheet_name)
            # 优先检查Rebate In Agreement Currency
            target_column = None
            if 'Rebate In Agreement Currency' in df.columns:
                target_column = 'Rebate In Agreement Currency'
            elif 'Vendor Funding In Agreement Currency' in df.columns:
                target_column = 'Vendor Funding In Agreement Currency'

            if target_column:
                # 转换为数值型，处理非数值数据
                df[target_column] = pd.to_numeric(df[target_column], errors='coerce')
                rebate_total = df[target_column].sum(skipna=True)
                total_amount += rebate_total
                total_rows += 1
            else:
                print(
                    f"{sheet_name}中既缺少'Rebate In Agreement Currency'列，也缺少'Vendor Funding In Agreement Currency'列")
        except Exception as e:
            print(f"处理{sheet_name}时发生错误: {e}")

    # 输出最终结果
    print("\n最终结果:")
    print(f"所有sheet的总金额: {total_amount}")
    print(f"所有sheet的总行数: {total_rows}")

    return total_amount, total_rows


def calculate_spa():
    # 使用示例
    file_path = '2025-07-23-14-41_US_spa.xlsx'  # 替换为你的Excel文件路径
    total_amount, total_rows = calculate_totals(file_path)

def sap():
    logger = ConsoleLog()
    page = ChromiumPage()
    spa = Spa(logger, page, "UK", "UK-VC")
    spa.result_file_name = "2025-07-21-15-29_UK_spa.xlsx"
    spa.push_data_queue()


calculate_spa()