# coding: utf-8

import pandas as pd

from app.vc import rabbit
from app.helper import domain, file
from app.logger.logger import Logger
from app.vc.interface import AutoInterface

from DrissionPage import ChromiumPage as Page
from datetime import datetime


class ProductSales(AutoInterface):
    def __init__(self, logger: Logger, page: Page, country: str):
        self.logger = logger
        self.page = page
        self.country = country

        # 获取当前日期和时间并格式化
        current_datetime = datetime.now().strftime('%Y-%m-%d-%H-%M')
        # 文件名
        self.result_file_name = f"products\\{current_datetime}_ProductSales.xlsx"

    def __page_get(self, url):
        host = domain.switch_domain(self.country)
        full_url = host + url
        self.page.get(full_url, timeout=5)

    def run(self, file_name: str):
        self.__page_get("retail-analytics/dashboard/sales?submit=true&time-period=daily")
        self.page.ele("#raw_xlsx_btn").click()
        self.logger.debug("点击导出等待下载任务提交...")
        self.page.wait(3)
        while True:
            self.page.ele("#downloadManager").click()
            self.logger.debug("等待数据加载...")
            self.page.wait(5)

            # 使用 XPath 定位元素
            xpath = '//kat-table-body/kat-table-row[1]/kat-table-cell[@role="cell"][1]/a'
            link = self.page.ele(f'xpath:{xpath}')
            if link is None:
                self.page.refresh()
                continue

            self.logger.debug("开始下载文件...")
            # 点击下载链接
            link.click.to_download(rename=self.result_file_name)
            self.logger.debug("等待下载...")
            file.wait_for_downloads(self.result_file_name,3600)
            break

    def push_data_queue(self):
        rabbit.connection()
        rabbit.connect(queue='product_sales', routing_key='product_sales', exchange='reports')

        df = pd.read_excel(self.result_file_name, header=1)
        # 过滤掉 Ordered Revenue <= 0 的数据
        data = df[df['Ordered Revenue'] > 0]

        for _, item_row in data.iterrows():
            push_data = {
                'asin': item_row.get('ASIN', ''),
                'ordered_revenue': item_row.get('Ordered Revenue', ''),  # 订单金额
                'ordered_units': item_row.get('Ordered Units', ''),  # 订单数量
            }
            # 推送数据
            rabbit.send_message(push_data)

        rabbit.close()
