import ttkbootstrap as ttk
from tkinter import filedialog, messagebox, scrolledtext
import threading
import time

# 创建主窗口
root = ttk.Window(themename="cosmo", minsize=(1000, 380), resizable=(False, False))
root.title("vendorCentral工具")

# 国家下拉框
country_label = ttk.Label(root, text="国家")
country_label.grid(row=0, column=0, padx=5, pady=5, sticky="w")

country_var = ttk.StringVar(value="US")  # 默认值为 "US"
country_combobox = ttk.Combobox(root, textvariable=country_var, values=["DE", "FR", "JP", "CA", "UK", "US"])
country_combobox.grid(row=0, column=1, padx=5, pady=5)

# 店铺编码下拉框
shop_code_label = ttk.Label(root, text="店铺")
shop_code_label.grid(row=1, column=0, padx=5, pady=5, sticky="w")

shop_code_var = ttk.StringVar(value="VECELO")
shop_code_combobox = ttk.Combobox(root, textvariable=shop_code_var,
                                  values=["DE-VC", "FR-VC", "JP-VC", "CA-VC", "UK-VC", "VECELO"])
shop_code_combobox.grid(row=1, column=1, padx=5, pady=5)

# 功能下拉框
action_label = ttk.Label(root, text="功能")
action_label.grid(row=2, column=0, padx=5, pady=5, sticky="w")

action_var = ttk.StringVar(value="请选择")
action_combobox = ttk.Combobox(root, textvariable=action_var, values=["spa", "return", "payment", "payment_erp"])
action_combobox.grid(row=2, column=1, padx=5, pady=5)

# 回款Code下拉框
payee_code_label = ttk.Label(root, text="code")
payee_code_label.grid(row=3, column=0, padx=5, pady=5, sticky="w")

payee_code_var = ttk.StringVar(value="VECET")  # 默认值为 "VECET"
payee_code_combobox = ttk.Combobox(root, textvariable=payee_code_var, values=["VECET"])
payee_code_combobox.grid(row=3, column=1, padx=5, pady=5)

# 文件名输入框
file_name_label = ttk.Label(root, text="文件")
file_name_label.grid(row=4, column=0, padx=5, pady=5, sticky="w")

file_name_var = ttk.StringVar(value="")  # 默认值为空
file_name_entry = ttk.Entry(root, textvariable=file_name_var)
file_name_entry.grid(row=4, column=1, padx=5, pady=5)


# 文件选择函数
def select_file():
    file = filedialog.askopenfilename(
        title="选择文件",
        filetypes=[("Excel 文件", "*.xls *.xlsx")]
    )
    if file:  # 如果用户选择了文件
        file_name_var.set(file)  # 将文件路径写入输入框


# 绑定点击事件
file_name_entry.bind("<Button-1>", lambda event: select_file())


# 提交按钮
def on_submit():
    # 禁用按钮
    submit_button.config(state="disabled")

    # 获取所有下拉框和输入框的值
    values = {
        "国家": country_var.get(),
        "店铺编码": shop_code_var.get(),
        "功能": action_var.get(),
        "回款Code": payee_code_var.get(),
        "文件名": file_name_var.get()
    }
    # 显示结果
    result = "\n".join([f"{key}: {value}" for key, value in values.items()])
    messagebox.showinfo("提交结果", result)

    # 模拟日志输出
    def log_simulation():
        for i in range(1, 6):
            time.sleep(1)  # 模拟耗时操作
            log_message = f"日志: 执行步骤 {i}\n"
            log_console.insert(ttk.END, log_message)
            log_console.see(ttk.END)  # 自动滚动到最新日志

        # 启用按钮
        submit_button.config(state="normal")

    # 使用线程避免阻塞主界面
    threading.Thread(target=log_simulation).start()


submit_button = ttk.Button(root, style="info", text="执行", width=25, command=on_submit)
submit_button.grid(row=5, column=0, columnspan=2, pady=5)

# 日志控制台
log_frame = ttk.Frame(root)  # 创建一个框架用于日志框和描述
log_frame.grid(row=0, column=2, rowspan=6, padx=10, pady=5)

# 日志框
log_console = scrolledtext.ScrolledText(log_frame, wrap=ttk.WORD, width=120, height=20)
log_console.pack(fill="both", expand=True, pady=10)

# 运行主循环
root.mainloop()
