# coding: utf-8
# 导出退款记录
import os
import time

import pandas as pd
from DrissionPage import ChromiumPage
from DrissionPage.errors import PageDisconnectedError

from helper import helper, excel

email = None
password = None

page = ChromiumPage()
page.set.load_mode.eager()
page.set.when_download_file_exists('overwrite')

# 下载目录
download_path = os.getcwd()
# 检查下载目录是否存在，如果不存在则创建
helper.make_dir(download_path)
# 设置下载路径，确保在打开浏览器前设置
page.set.download_path(download_path)


def open_url(url):
    # 访问网页
    page.get(url)

    element = page.ele('#ap_email', timeout=1)
    if element:
        page.ele('#ap_email').input(email)
        page.ele('#continue').click()
        page.ele('#ap_password').input(password)
        page.ele('#signInSubmit').click()

    # 判断是否有图形码
    while True:
        time.sleep(1)

        if not page.ele('.a-section a-text-center cvf-captcha-img'):
            break

        print("请填入图形码内容")
        # todo 识别图形码


def main():
    # 读取asin和sku映射关系
    relations_dict = asin_sku_relations()

    # 下载并读取list数据
    list_data = export_list()

    new_list_data = []
    for _, data in list_data.iterrows():
        return_id = data.get('Return ID')
        # 下载退货详情表格读取数据
        item_data = export_item(return_id)
        # 按 'Purchase order' 和 'ASIN' 分组，并对 'Quantity' 和 Total amount 进行求和
        item_data_result = item_data.groupby(['Purchase order', 'ASIN'], as_index=False).agg({
            'Quantity': 'sum',
            'Total amount': 'sum',
        })

        for _, item_row in item_data_result.iterrows():
            data_dict = data.to_dict()
            data_dict['Return Date'] = data_dict['Return Date'].strftime('%m/%d/%Y')
            data_dict['Return ID'] = str(data_dict['Return ID'])
            data_dict['PO'] = item_row.get('Purchase order')
            data_dict['ASIN'] = item_row.get('ASIN')
            data_dict['SKU'] = relations_dict[item_row.get('ASIN')]
            data_dict['Quantity'] = item_row.get('Quantity')

            # 替换回会数量和金额为详情里面的值
            data_dict['Return quantity'] = item_row.get('Quantity')
            data_dict['Total cost'] = item_row.get('Total amount')

            # 追加数据
            new_list_data.append(data_dict)

    excel.save_xls(new_list_data, '退货明细.xlsx')
    page.close()


def asin_sku_relations():
    relations_dict = {}
    # 读取ASIN和sku映射关系
    df = pd.read_excel('relations.xlsx')
    for index, row in df.iterrows():
        row_dict = row.to_dict()
        relations_dict[row_dict['ASIN']] = row_dict['SKU']

    return relations_dict


def export_list():
    # 访问网页
    open_url("https://vendorcentral.amazon.com/hz/vendor/members/returns?ref_=vc_xx_subNav")

    # 导出退货单
    page.ele("#file-download-button").click.to_download()
    page.download.wait()
    return pd.read_excel('Return_Summary.xls', engine='xlrd')


def export_item(return_id):
    returns_dir = "returns"
    helper.make_dir(returns_dir)

    file_name = f"{returns_dir}\\{return_id}.xls"
    if not os.path.isfile(file_name):
        # 打开退回详情下载明细
        open_url(f"https://vendorcentral.amazon.com/katalmonsapp/vendor/members/returns/{return_id}")
        page.ele("#file-download-button").click.to_download(rename=file_name)
        page.download.wait()

    # 读取回退商品详情
    return pd.read_excel(file_name, engine='xlrd')


if __name__ == '__main__':
    try:
        email = helper.get_input_with_default("请输入账户", "us-cs001@khdtek.com")
        print(f"您输入的账户是:{email}")
        password = helper.get_input_with_default("请输入密码", "khd=20221208")
        print(f"您输入的密码是:{password}")

        main()
    except KeyboardInterrupt:
        pass
    except PageDisconnectedError as e:
        print("与页面的连接已断开")
