# coding: utf-8
# 回款明细
import os
import time
import urllib.parse
import warnings

import pandas as pd
from DrissionPage import ChromiumPage
from DrissionPage.errors import PageDisconnectedError

from helper import helper

page = ChromiumPage()
page.set.load_mode.normal()
page.set.when_download_file_exists('overwrite')
# 下载目录
download_path = os.getcwd()
# 检查下载目录是否存在，如果不存在则创建
helper.make_dir(download_path)
# 设置下载路径，确保在打开浏览器前设置
page.set.download_path(download_path)

# 忽略 openpyxl 样式警告
warnings.filterwarnings("ignore", category=UserWarning, module="openpyxl")


# 对过滤后的数据，进一步处理 Description 列
def process_description(description):
    # 按空格分割最后一段
    parts = description.split('/')
    # 检查分割后的最后一个部分的前面是否为8位数
    if len(parts) > 0 and len(parts[-1]) >= 8:
        # 返回分割后的前8位
        return parts[-1][:8]
    return None


def download_filter_data():
    file_name = 'Payments.xlsx'
    if not os.path.isfile(file_name):
        page.get(f"https://vendorcentral.amazon.com/hz/vendor/members/remittance/home")
        page.ele("#remittance-home-select-all").click()
        page.ele("#remittance-home-export-link").click.to_download()
        page.download.wait()

    df = pd.read_excel('Payments.xlsx', skiprows=22)
    # 定义正则表达式模式，匹配包含 'Price' 或 'PCR' 或 'XXXXXXXX/XXXX/' 的描述
    pattern = r'Price|PCR|Missed|Shortage|^[A-Z0-9]{8}/[A-Z0-9]{4}/'
    # 过滤符合条件的行
    return df[df['Description'].str.contains(pattern, na=False, regex=True)]


def main():
    list_data = download_filter_data()
    for _, data in list_data.iterrows():
        invoice_number = data.get("Invoice Number")
        description = data.get("Description")
        if "Price" in description or "PCR" in description or "Missed" in description or "Shortage" in description:
            # 获取前8位
            invoice_number = invoice_number[:8]

        print(invoice_number)

        page.get(
            f"https://vendorcentral.amazon.com/hz/vendor/members/inv-mgmt/invoice-po-search?searchByNumberToken={invoice_number}")

        params = {
            "invoiceNumber": invoice_number,
            "payeeCode": "VECET",
            "activeTab": "lineItems",
        }
        # 将字典转换为 URL 查询参数
        query_string = urllib.parse.urlencode(params)
        page.get(f"https://vendorcentral.amazon.com/hz/vendor/members/inv-mgmt/invoice-details?" + query_string)

        # 读取详情内容
        file_name = f"invoices\\{invoice_number}.csv"
        page.ele("#line-items-export-to-spreadsheet-announce").click.to_download(rename=file_name)
        time.sleep(3)

        detail_data = pd.read_csv(file_name, skiprows=2, engine='python', on_bad_lines='skip')
        # for _, detail, in detail_data.iterrows():
        #     print(f"{detail.to_dict()}")


if __name__ == '__main__':
    try:
        main()
    except KeyboardInterrupt:
        pass
    except PageDisconnectedError as e:
        print("与页面的连接已断开")
