# coding: utf-8
import os
import time


def wait_for_downloads(download_dir, timeout=60):
    """
    监控下载目录，等待新文件下载完成。
    :param download_dir: 文件下载目录
    :param timeout: 超时时间，单位：秒
    """
    end_time = time.time() + timeout
    while time.time() < end_time:
        files = os.listdir(download_dir)
        if files:  # 如果文件夹内有文件
            return True
        time.sleep(1)
    return False


def make_dir(path):
    # 检查下载目录是否存在，如果不存在则创建
    if not os.path.exists(path):
        os.makedirs(path)
        return False

    return True
