# coding: utf-8
# 回款明细
import os

import pandas as pd
from DrissionPage import ChromiumPage
from DrissionPage.errors import PageDisconnectedError

from helper import helper

page = ChromiumPage()
page.set.load_mode.eager()
page.set.when_download_file_exists('overwrite')

# 下载目录
download_path = os.getcwd()
# 检查下载目录是否存在，如果不存在则创建
helper.make_dir(download_path)
# 设置下载路径，确保在打开浏览器前设置
page.set.download_path(download_path)


def main():
    page.get("https://vendorcentral.amazon.com/hz/vendor/members/coop?ref_=vc_xx_subNav")
    # 全选
    page.ele("#select-all").click()
    # 点击选项卡
    page.ele("#cc-invoice-actions-dropdown").click()
    # 点击下载报表
    page.ele("#cc-invoice-actions-dropdown_2").click.to_download()
    page.download.wait()

    file_name = "ContraCogsInvoices.xls"
    coop_data = pd.read_excel(file_name, engine='xlrd')
    for _, data in coop_data.iterrows():
        # 根据回款id搜索下载报表
        invoice_id = data.get("Invoice ID")
        page.get(f"https://vendorcentral.amazon.com/hz/vendor/members/coop?searchText={invoice_id}")
        # 点击选项卡
        page.ele("#a-autoid-2-announce").click()
        # 下载报表
        file_name = f"coop\\{invoice_id}.csv"
        page.ele(f"#invoiceDownloads-{invoice_id}_1").click.to_download(rename=file_name)

        # invoice_data = pd.read_csv(file_name)
        # for _, invoice, in invoice_data.iterrows():
        #     print(f"{invoice.to_dict()}")


if __name__ == '__main__':
    try:
        main()
    except KeyboardInterrupt:
        pass
    except PageDisconnectedError as e:
        print("与页面的连接已断开")
