@echo off
setlocal

:: 设置 Python 下载链接和目标安装目录
set "PYTHON_VERSION=3.10.10"
set "PYTHON_INSTALLER=python-%PYTHON_VERSION%-amd64.exe"
set "TARGET_DIR=D:\app\Python"

:: 下载 Python 安装程序
echo Downloading Python %PYTHON_VERSION%...
powershell -Command "Invoke-WebRequest -Uri https://www.python.org/ftp/python/%PYTHON_VERSION%/%PYTHON_INSTALLER% -OutFile %PYTHON_INSTALLER%"

:: 静默安装 Python
echo Installing Python...
start /wait %PYTHON_INSTALLER% /quiet InstallAllUsers=1 PrependPath=1 TargetDir="%TARGET_DIR%"

:: 清理下载的安装程序
echo Cleaning up...
del %PYTHON_INSTALLER%

echo Python %PYTHON_VERSION% has been installed to %TARGET_DIR%.

:: 检查 Python 版本
"%TARGET_DIR%\python.exe" --version

echo Installing required packages...
:: "%TARGET_DIR%\pip.exe" install --no-warn-script-location -i https://mirrors.cloud.tencent.com/pypi/simple -r requirements.txt

endlocal
pause
