# coding: utf-8
import os
import re
import sys
import traceback


def get_input_with_default(prompt, default):
    user_input = input(f"{prompt}; ( 默认'{default}'):")
    return user_input.upper() or default


def print_trace(title: str, err):
    print("-----------{}:出错-----------".format(title))
    except_type, _, except_traceback = sys.exc_info()
    err_str = ','.join(str(i) for i in err.args)
    print(except_type)
    print(err_str)
    for i in traceback.extract_tb(except_traceback):
        print("函数{},文件:{},行:{}".format(i.name, i.filename, i.lineno))

def extract_numeric_value(value):
    """
    从包含货币符号的字符串中提取纯数字
    参数:
        value: 输入值（可以是字符串、数字或NaN）
    返回:
        float: 提取的数字值，如果输入无效则返回0.0
    """
    str_value = str(value).strip()

    # 处理千分位分隔符（如1,000.00）
    str_value = str_value.replace(',', '')

    # 移除非数字字符（保留数字和小数点）
    numeric_str = re.sub(r'[^\d.]', '', str_value)

    try:
        return float(numeric_str) if numeric_str else 0.0
    except ValueError:
        return 0.0
