# coding: utf-8
import os

from DrissionPage import ChromiumPage
from dotenv import load_dotenv

from app.helper import domain, helper
from app.helper.logger import ConsoleLog
from app.vc.payment import Payment
from app.vc.payment_push import PaymentPush
from app.vc.return_goods import ReturnGoods
from app.vc.spa import Spa

if __name__ == '__main__':
    load_dotenv()

    page = ChromiumPage()
    page.set.load_mode.normal()
    page.set.when_download_file_exists('overwrite')
    # 下载目录
    download_path = os.getcwd()
    # 设置下载路径，确保在打开浏览器前设置
    page.set.download_path(download_path)

    try:
        country = helper.get_input_with_default("国家: [ DE, FR, JP, CA, UK, US ]", "US")
        shop_code = helper.get_input_with_default("店铺编码: [ DE-VC, FR-VC, JP-VC, CA-VC, UK-VC, VECELO ]", "VECELO")
        action = helper.get_input_with_default("功能:[ spa, return, payment, payment_erp ]", "")
        if action == "":
            raise Exception("请输入要执行的功能")

        logger = ConsoleLog()

        if action.lower() == "payment":
            payee_code = helper.get_input_with_default("回款Code: [ 详情页url参数 payeeCode ]", "VECET")
            object_instate = Payment(logger, page, country, payee_code, shop_code)
        if action.lower() == "payment_erp":
            object_instate = PaymentPush(logger, country, shop_code)
        elif action.lower() == "return":
            object_instate = ReturnGoods(logger, page, country, shop_code)
        elif action.lower() == "spa":
            object_instate = Spa(logger, page, country, shop_code)
        else:
            raise Exception("请输入正确的功能")

        file_name = helper.get_input_with_default("文件名 : [ 例如: ContraCogsInvoices.xls ]", "")
        if file_name == "":
            raise Exception("请输入文件名")

        # 切换域名
        domain.domain_page(logger, page, country)
        # 执行功能
        object_instate.run(file_name)
        # 推送数据到队列中
        object_instate.push_data_queue()
    except KeyboardInterrupt:
        pass
    except Exception as e:
        helper.print_trace("main", e)
    finally:
        page.close()
