# coding: utf-8
import time

from lxml import etree


def switch_domain(country):
    domain = "https://vendorcentral.amazon.com/"

    if country == "JP":
        domain = "https://vendorcentral.amazon.co.jp/"
    if country == "UK":
        domain = "https://vendorcentral.amazon.co.uk/"
    if country == "FR":
        domain = "https://vendorcentral.amazon.fr/"
    if country == "DE":
        domain = "https://vendorcentral.amazon.de/"
    if country == "CA":
        domain = "https://vendorcentral.amazon.ca/"
    if country == "mx":
        domain = "https://vendorcentral.amazon.com.mx/"

    return domain


class LoginDomain:
    def __init__(self, logger, page, country):
        self.logger = logger
        self.page = page
        self.country = country

        # 运行状态
        self.running = False

    def set_status(self, status):
        self.running = status

    def login_check(self):
        url = switch_domain(self.country)
        self.page.get(url)
        while True:
            while not self.running:
                time.sleep(1)

            time.sleep(3)
            title = self.page.title
            valid_titles = [
                "Amazon Sign-In",
                "Amazon Sign In",
                "Connexion Amazon",
                "Amazonサインイン",
                "Amazon Iniciar sesión",
                "Connexion Amazon",
                "Amazon Anmelden",
            ]
            if title in valid_titles:
                self.logger.info("请登录账号")
                continue

            code_title = [
                "Authentication required",
                "Two-Step Verification"
            ]
            if title in code_title:
                self.logger.info("请输入图形验证码")
                continue

            tree = etree.HTML(self.page.html)
            element = tree.xpath('//*[@id="cvf-submit-otp-button-announce"]')
            if element:
                self.logger.info('请输入验证码')
            else:
                break
