# coding: utf-8

from abc import ABC, abstractmethod
import time


# 定义一个接口
class AutoInterface(ABC):
    def __init__(self):
        self._running = True  # 运行状态标志
    
    def set_running(self, status: bool):
        """设置运行状态"""
        self._running = status
    
    def is_running(self) -> bool:
        """获取运行状态"""
        return self._running
    
    def check_pause(self):
        """检查暂停状态，如果暂停则等待"""
        while not self._running:
            time.sleep(0.5)
    
    @abstractmethod
    def run(self, file_name: str):
        pass

    @abstractmethod
    def push_data_queue(self):
        pass
