# coding: utf-8
import os
import redis


class RedisClient:
    _instance = None

    def __new__(cls):
        if not cls._instance:
            cls._instance = super(RedisClient, cls).__new__(cls)
            cls._instance._initialize()
        return cls._instance

    def _initialize(self):
        host = os.getenv('REDIS_HOST', '47.119.182.76')
        port = os.getenv('REDIS_PORT', 6379)
        db = os.getenv('REDIS_DB', 12)
        password = os.getenv('REDIS_PASSWORD', 'khd2022!')
        self.client = redis.StrictRedis(host=host, port=port, db=db, password=password, decode_responses=True)

    def get_client(self):
        return self.client
