# coding: utf-8
# 回款明细
import os

import pandas as pd
from DrissionPage import ChromiumPage
from DrissionPage.errors import PageDisconnectedError

from helper import helper

page = ChromiumPage()
page.set.load_mode.normal()
page.set.when_download_file_exists('overwrite')
# 下载目录
download_path = os.getcwd()
# 检查下载目录是否存在，如果不存在则创建
helper.make_dir(download_path)
# 设置下载路径，确保在打开浏览器前设置
page.set.download_path(download_path)


def main():
    po = "74HDTI2S"
    page.get(
        f"https://vendorcentral.amazon.com/hz/vendor/members/inv-mgmt/invoice-details?invoiceNumber={po}&payeeCode=VECET&activeTab=lineItems")
    try:
        invoice_dir = "invoices"
        file_name = f"{invoice_dir}\\{po}.csv"
        mission = page.ele("#line-items-export-to-spreadsheet-announce").click.to_download(rename=file_name)
        mission.wait()

        detail_data = pd.read_csv(file_name, skiprows=2)
        for _, data, in detail_data.iterrows():
            print(f"{data.to_dict()}")

    except Exception as err:
        print(f"读取 CSV 文件时出错: {err}")


if __name__ == '__main__':
    try:
        main()
    except KeyboardInterrupt:
        pass
    except PageDisconnectedError as e:
        print("与页面的连接已断开")
