# coding: utf-8
import os

import pandas as pd
import xlrd
from openpyxl.reader.excel import load_workbook


def open_xls(file_path):
    # 开始处理excel数据
    workbook = xlrd.open_workbook(filename=file_path)
    # 选择工作表
    return workbook.sheet_by_index(0)  # 选择第一个工作表


def save_xls(data, output_file):
    df = pd.DataFrame(data)
    # 将 DataFrame 写入 Excel 文件
    df.to_excel(output_file, index=False)  # index=False 表示不写入行索引
    # 使用 openpyxl 重新加载工作簿
    wb = load_workbook(output_file)
    ws = wb.active  # 获取活动工作表

    # 自动调整列宽
    for column in ws.columns:
        max_length = 0
        # 获取列字母
        column_letter = column[0].column_letter
        for cell in column:
            try:
                if len(str(cell.value)) > max_length:
                    max_length = len(str(cell.value))
            except:
                pass
        # 增加一些宽度以美观
        adjusted_width = (max_length + 2)
        ws.column_dimensions[column_letter].width = adjusted_width

    # 保存调整后的工作簿
    wb.save(output_file)


def make_dir(path):
    # 检查下载目录是否存在，如果不存在则创建
    if not os.path.exists(path):
        os.makedirs(path)
        return False

    return True


def get_input_with_default(prompt, default):
    user_input = input(f"{prompt}(默认为 '{default}'):")
    return user_input or default
