@echo off

setlocal

set "PYTHON_VERSION=3.10.10"
set "PYTHON_INSTALLER=python-%PYTHON_VERSION%-amd64.exe"
set "TARGET_DIR=D:\app\Python"

echo Downloading Python %PYTHON_VERSION%...
powershell -Command "Invoke-WebRequest -Uri https://www.python.org/ftp/python/%PYTHON_VERSION%/%PYTHON_INSTALLER% -OutFile %PYTHON_INSTALLER%"

echo Installing Python...
start /wait %PYTHON_INSTALLER% /quiet InstallAllUsers=1 PrependPath=1 TargetDir="%TARGET_DIR%"

echo Cleaning up...
del %PYTHON_INSTALLER%

echo Python %PYTHON_VERSION% has been installed to %TARGET_DIR%.

"%TARGET_DIR%\python.exe" --version

echo Installing required packages...
"%TARGET_DIR%\pip.exe" install --no-warn-script-location -i https://mirrors.cloud.tencent.com/pypi/simple -r requirements.txt

endlocal

pause
