# coding: utf-8
import os
import time


def wait_for_downloads(file_name, timeout=60):
    """
    监控下载文件，等待新文件下载完成。
    :param file_name: 文件下载目录
    :param timeout: 超时时间，单位：秒
    """
    end_time = time.time() + timeout
    while time.time() < end_time:
        files = os.path.isfile(file_name)
        if files:
            return True
        time.sleep(1)
    return False


def make_dir(path):
    # 检查下载目录是否存在，如果不存在则创建
    if not os.path.exists(path):
        os.makedirs(path)
        return False

    return True
