# coding: utf-8
# 回款明细
import os
import warnings

import pandas as pd
from DrissionPage import ChromiumPage
from DrissionPage.errors import ElementNotFoundError
from dotenv import load_dotenv

from helper import helper, file, domain, logger, redisx, rabbitmq

country = None
payeeCode = None
shop_code = None

load_dotenv()

log = logger.ConsoleLog()
rdb = redisx.RedisClient()

page = ChromiumPage()
page.set.load_mode.normal()
page.set.when_download_file_exists('overwrite')
# 下载目录
download_path = os.getcwd()
# 检查下载目录是否存在，如果不存在则创建
helper.make_dir(download_path)
# 设置下载路径，确保在打开浏览器前设置
page.set.download_path(download_path)

# 忽略 openpyxl 样式警告
warnings.filterwarnings("ignore", category=UserWarning, module="openpyxl")


def page_get(url):
    host = domain.switch_domain(country)
    full_url = host + url
    page.get(full_url, timeout=5)


def export_list_read_data():
    file_name = 'Payments.xlsx'

    try:
        while True:
            page_get(f"hz/vendor/members/remittance/home")

            # 选择日期下拉框
            page.ele("#date-range-option-wrap").click()
            page.wait(1)
            # 点击第一个选项
            page.ele("#date-range-option_0").click()
            page.wait(1)
            # 点击搜索按钮
            page.ele("#remittanceSearchForm-submit-aui-button").click()
            page.wait(2)

            page.ele("#remittance-home-select-all").click()
            page.ele("#remittance-home-export-link").click.to_download()
            is_down = file.wait_for_downloads(file_name, 30)
            if is_down: break
            log.warning(f"下载失败,重新下载")
    except ElementNotFoundError:
        log.error("页面加载失败,刷新重新加载")
        page.refresh()

    all_df = pd.read_excel(file_name, header=None, keep_default_na=False, na_values=[])

    # 找到所有空行的索引，这里假设完全空的行为表头之间的分界线
    empty_rows = all_df[all_df.isnull().all(axis=1)].index.tolist()

    # 定位表头与数据的分隔
    first_header_start = empty_rows[1] + 1  # 第一个表头开始的行
    second_header_start = empty_rows[2] + 4  # 第二个表头开始的行

    payments = pd.read_excel(file_name, skiprows=first_header_start, nrows=second_header_start - 7)
    invoices = pd.read_excel(file_name, skiprows=second_header_start)

    return [payments, invoices]


def main():
    payments, invoices = export_list_read_data()

    # 将 'Payment Number' 列设置为索引
    payments.set_index('Payment Number', inplace=True)

    # 转换为字典，orient='index' 表示以索引为键
    payments_map = payments.to_dict(orient='index')

    log.info(f"共计：{len(invoices)} 订单")

    rabbit = rabbitmq.RabbitMQClient()
    rabbit.connect(queue='refund_robot', routing_key='refund_robot', exchange='reports')

    i = 0
    for _, data in invoices.iterrows():
        i += 1
        payment_number = data.get("Payment Number")

        payment_date = payments_map.get(payment_number, {}).get('Payment Date', '')

        push_data = {
            'payment_number': data.get('Payment Number', ''),  # 订单id
            'order_date': str(data.get('Invoice Date', '')),  # 发票时间
            'payment_date': str(payment_date),
            'order_no': data.get('Invoice Number', 0),  # 订单号
            'payment_type': data.get('Description', ''),  # Description
            'platform_payable_amount': data.get('Invoice Amount', ''),  # 平台应付金额
            'fee_amount': data.get("Terms Discount Taken", ''),  # 手续费
            'actual_payment': data.get('Amount Paid', ''),  # 实际支付金额
            'currency': data.get('Invoice Currency', ''),  # 货币
            'shop_code': shop_code,  # 店铺code
        }

        # 推送数据
        rabbit.send_message(push_data)


if __name__ == '__main__':
    try:
        country = helper.get_input_with_default("国家(目前支持[DE,FR,JP,CA,UK,US])", "US")
        payeeCode = helper.get_input_with_default("payeeCode", "VECET")
        shop_code = helper.get_input_with_default("店铺编码", "US-VC")
        domain.domain_page(page, country)
        main()
        page.close()
    except KeyboardInterrupt:
        pass
    except Exception as e:
        log.error(e)
        helper.print_trace("main", e)
