# coding: utf-8
from huey import RedisHuey

import bootstrap
from models import Store, Goods

bootstrap.init()

config = bootstrap.config
host = config.get('redis', 'host')
port = config.get('redis', 'port')
db = config.get('redis', 'db')
password = config.get('redis', 'password')
# 创建 Huey 应用，指定 Redis 配置
huey = RedisHuey(host=host, port=port, db=db, password=password)


@huey.task()
def process_data(data: dict):
    orm = bootstrap.db_session()
    try:
        store_name = data['store_name']
        # 查询店铺是否存在
        store_res = orm.query(Store).filter_by(name=store_name).first()
        if not store_res:
            store_data = Store(name=store_name)
            orm.add(store_data)
            orm.commit()
            store_id = store_data.id
        else:
            store_id = store_res.id

        goods_name = data['goods_name']
        goods_res = orm.query(Goods).filter_by(name=goods_name).first()
        if not goods_res:
            goods_data = Goods(store_id=store_id, name=goods_name, image=data['img_src'], url=data['url'])
            orm.add(goods_data)
            orm.commit()

    except Exception as e:
        print(f"Error: {e}")
    finally:
        orm.close()
