# coding: utf-8
import queue
import time

from app.logger.logger import Logger


class GuiLog(Logger):
    _instance = None
    _log_queue = None

    def __new__(cls, *args, **kwargs):
        if not cls._instance:
            cls._instance = super(GuiLog, cls).__new__(cls)
            # 全局队列，用于传递日志消息
            cls._queue = queue.Queue()
        return cls._instance

    def set_console(self, log_queue):
        self._log_queue = log_queue

    def info(self, arg):
        self.__message("INFO", arg)

    def debug(self, arg):
        self.__message("DEBUG", arg)

    def warning(self, arg):
        self.__message("WARN", arg)

    def error(self, arg):
        self.__message("ERROR", arg)

    def __message(self, t, message):
        self._log_queue.put(f"[{t}] {message}")
