# coding: utf-8
from sqlalchemy import Column, Integer, String, Text
from sqlalchemy.orm import declarative_base

# 创建基础类
Base = declarative_base()


class BaseModel(Base):
    __abstract__ = True
    __table_args__ = {
        'mysql_engine': 'InnoDB',  # 指定全局的 InnoDB 引擎
        'mysql_charset': 'utf8mb4'  # 设置字符集
    }


class Store(BaseModel):
    __tablename__ = 'store'
    id = Column(Integer, primary_key=True)
    name = Column(String(100), comment='店铺名称')
    code = Column(String(50), comment='店铺编码')
    __table_args__ = ({'comment': '店铺表'})


class Category(BaseModel):
    __tablename__ = 'category'
    id = Column(Integer, primary_key=True)
    name = Column(String(50), comment='分类名称')
    __table_args__ = ({'comment': '商品分类表'})


class Goods(BaseModel):
    __tablename__ = 'goods'
    id = Column(Integer, primary_key=True)
    store_id = Column(Integer, comment='门店id')
    name = Column(String(255), comment='商品名称')
    image = Column(String(255), comment='商品图片')
    url = Column(Text, comment='商品地址')
    __table_args__ = ({'comment': '商品表'})


class Comment(BaseModel):
    __tablename__ = 'comments'
    id = Column(Integer, primary_key=True)
    content = Column(String(50), comment='内容')
    goods_id = Column(Integer, comment='商品id')
    store_id = Column(Integer, comment='门店id')
    __table_args__ = ({'comment': '商品信息表'})
