# coding: utf-8
# 回款明细
import os
import warnings

import pandas as pd
from DrissionPage import ChromiumPage
from DrissionPage.errors import ElementNotFoundError
from dotenv import load_dotenv

from helper import helper, file, domain, logger, redisx, rabbitmq

country = None
shop_code = None

load_dotenv()

log = logger.ConsoleLog()
rdb = redisx.RedisClient()

page = ChromiumPage()
page.set.load_mode.normal()
page.set.when_download_file_exists('overwrite')
# 下载目录
download_path = os.getcwd()
# 检查下载目录是否存在，如果不存在则创建
helper.make_dir(download_path)
# 设置下载路径，确保在打开浏览器前设置
page.set.download_path(download_path)

# 忽略 openpyxl 样式警告
warnings.filterwarnings("ignore", category=UserWarning, module="openpyxl")


def page_get(url):
    host = domain.switch_domain(country)
    full_url = host + url
    page.get(full_url, timeout=5)


def export_list_read_data():
    file_name = 'Payments.xlsx'

    # try:
    #     while True:
    #         page_get(f"hz/vendor/members/remittance/home")
    #
    #         # 选择日期下拉框
    #         page.ele("#date-range-option-wrap").click()
    #         page.wait(1)
    #         # 点击第一个选项
    #         page.ele("#date-range-option_0").click()
    #         page.wait(1)
    #         # 点击搜索按钮
    #         page.ele("#remittanceSearchForm-submit-aui-button").click()
    #         page.wait(2)
    #
    #         page.ele("#remittance-home-select-all").click()
    #         page.ele("#remittance-home-export-link").click.to_download()
    #         is_down = file.wait_for_downloads(file_name, 30)
    #         if is_down: break
    #         log.warning(f"下载失败,重新下载")
    # except ElementNotFoundError:
    #     log.error("页面加载失败,刷新重新加载")
    #     page.refresh()

    df = pd.read_excel(file_name, header=None)

    # 定位标题行
    pay_title = df[df[0].str.contains('Remittance payments', case=False, na=False)].index[0]
    inv_title = df[df[0].str.contains('Invoices', case=False, na=False)].index[0]

    # 定位表头起始行（跳过标题后的空行）
    pay_header = df.loc[pay_title + 1:].notna().any(axis=1).idxmax()
    inv_header = df.loc[inv_title + 1:].notna().any(axis=1).idxmax()

    # 计算第一个表格的结束位置（第二个标题前的空行）
    empty_lines = df.index[df.isnull().all(axis=1)].tolist()
    separator = max([x for x in empty_lines if pay_header < x < inv_title], default=inv_title - 1)

    # 读取并清理数据
    test = separator - pay_header - 1
    payments = pd.read_excel(file_name, header=pay_header, nrows=test).dropna(how='all')
    invoices = pd.read_excel(file_name, header=inv_header).dropna(how='all')

    return [payments, invoices]


def main():
    payments, invoices = export_list_read_data()

    # 将 'Payment Number' 列设置为索引
    payments.set_index('Payment Number', inplace=True)

    # 转换为字典，orient='index' 表示以索引为键
    payments_map = payments.to_dict(orient='index')

    log.info(f"共计：{len(invoices)} 订单")

    rabbit = rabbitmq.RabbitMQClient()
    rabbit.connect(queue='refund_robot', routing_key='refund_robot', exchange='reports')

    i = 0
    for _, data in invoices.iterrows():
        i += 1
        payment_number = data.get("Payment Number")

        payment_date = payments_map.get(payment_number, {}).get('Payment Date', '')

        platform_payable_amount = data.get('Invoice Amount', '')
        if country == 'FR' or country == 'UK':
            platform_payable_amount = data.get('Net Amount Paid', '')

        push_data = {
            'payment_number': data.get('Payment Number', ''),  # 订单id
            'order_date': str(data.get('Invoice Date', '')),  # 发票时间
            'payment_date': str(payment_date),
            'order_no': data.get('Invoice Number', 0),  # 订单号
            'payment_type': data.get('Description', ''),  # Description
            'platform_payable_amount': platform_payable_amount,  # 平台应付金额
            'fee_amount': data.get("Terms Discount Taken", ''),  # 手续费
            'actual_payment': data.get('Amount Paid', ''),  # 实际支付金额
            'currency': data.get('Invoice Currency', ''),  # 货币
            'shop_code': shop_code,  # 店铺code
        }

        # 推送数据
        rabbit.send_message(push_data)


if __name__ == '__main__':
    try:
        country = helper.get_input_with_default("国家(目前支持[DE,FR,JP,CA,UK,US])", "US")
        shop_code = helper.get_input_with_default("店铺编码(DE-VC,FR-VC,JP-VC,CA-VC,UK-VC,VECELO])", "VECELO")
        domain.domain_page(page, country)
        main()
    except KeyboardInterrupt:
        pass
    except Exception as e:
        log.error(e)
        helper.print_trace("main", e)
