# coding: utf-8
import os
import sys
import traceback


def make_dir(path):
    # 检查下载目录是否存在，如果不存在则创建
    if not os.path.exists(path):
        os.makedirs(path)
        return False

    return True


def get_input_with_default(prompt, default):
    user_input = input(f"{prompt}(默认为 '{default}'):")
    return user_input.upper() or default


def print_trace(title: str, err):
    print("-----------{}:出错-----------".format(title))
    except_type, _, except_traceback = sys.exc_info()
    err_str = ','.join(str(i) for i in err.args)
    print(except_type)
    print(err_str)
    for i in traceback.extract_tb(except_traceback):
        print("函数{},文件:{},行:{}".format(i.name, i.filename, i.lineno))
